// $Id: CMouse.cpp,v 1.3 2007/02/08 21:07:54 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CMouse.hpp"
using Exponent::GUI::Windowing::CMouse;

//	===========================================================================
CMouse::CMouse(const CPoint &point, CCursor *cursor) : m_cursor(NULL)
{
	this->setPosition(point);
	this->setCursor(cursor);
}

#ifdef WIN32
//	===========================================================================
CMouse::CMouse(LPARAM lParam, CCursor *cursor) : m_cursor(NULL)
{
	this->setPosition(lParam);
	this->setCursor(cursor);
}
#endif

//	===========================================================================
CMouse::CMouse() : m_cursor(NULL)
{
	this->setPosition(CPoint());
	this->setCursor();
}

//	===========================================================================
CMouse::~CMouse()
{
	// Nothing to do
}

//	===========================================================================
void CMouse::setPosition(const CPoint &point)
{
	m_position = point;
}

#ifdef WIN32
//	===========================================================================
void CMouse::setPosition(LPARAM lParam)
{
	this->setPosition(CPoint(LOWORD(lParam), HIWORD(lParam)));
}
#endif

//	===========================================================================
void CMouse::setCursor(CCursor *cursor)
{
	if (cursor)
	{
		m_cursor = cursor;
	#ifdef WIN32
		SetCursor(cursor->getCursor());
	#else
		cursor->setCursor(cursor->getCursorId());
	#endif
	}
}

//	===========================================================================
void CMouse::capture(SWindowHandle *windowHandle) const
{
#ifdef WIN32
	SetCapture(windowHandle->m_windowHandle);
#else
	// No mac equivalent...s
#endif
}

//	===========================================================================
void CMouse::release() const
{
#ifdef WIN32
	ReleaseCapture();
#else
	// No equivalent
#endif
}

//	===========================================================================
bool CMouse::isCaptured() const
{
#ifdef WIN32
	HWND handle = GetCapture();
	if (handle == NULL)
	{
		return false;
	}
	else
	{
		return true;
	}
#else
	return false;		// IsButtonDown??
#endif
}

//	===========================================================================
bool CMouse::isCaptured(SWindowHandle *windowHandle) const
{
#ifdef WIN32
	HWND handle = GetCapture();
	if (handle == windowHandle->m_windowHandle)
	{
		return true;
	}
	return false;
#else
	return false;
#endif
}